<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);

$baseUrl = "https://api.controlmaxerp.com.br";
$instance = "APIOficialW7master";
$token = "E2FE47D54167-4285-9B9E-9A462908E39E";

// Formato correto do número (com @s.whatsapp.net)
$numero = "5511958438308@s.whatsapp.net";
$mensagem = "Teste de envio via Evolution API";

// Endpoint correto para Evolution API v2
$url = $baseUrl . "/message/sendText/" . $instance;

// Dados no formato esperado pela Evolution API
$data = [
    "number" => $numero,
    "text" => $mensagem,
    "delay" => 1200 // Opcional: delay em ms entre mensagens
];

// Headers corretos
$headers = [
    "Content-Type: application/json",
    "apikey: " . $token  // Evolution API usa 'apikey' não 'Authorization'
];

echo "🔄 Enviando mensagem...\n";
echo "URL: $url\n";
echo "Número: $numero\n\n";

// cURL
$ch = curl_init($url);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
curl_setopt($ch, CURLOPT_TIMEOUT, 30);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$curlError = curl_error($ch);
curl_close($ch);

// Exibe resultado detalhado
echo "📊 Resultado:\n";
echo "HTTP Code: $httpCode\n";

if($curlError) {
    echo "❌ Erro cURL: $curlError\n";
}

echo "Resposta da API:\n";
echo $response . "\n";

// Decodifica resposta para análise
$responseData = json_decode($response, true);
if(json_last_error() === JSON_ERROR_NONE) {
    echo "\n📋 Resposta decodificada:\n";
    print_r($responseData);
} else {
    echo "\n⚠️ Resposta não é JSON válido\n";
}
?>