<?php
// client-api/index.php - VERSÃO COM QUERY STRING
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');
header('Content-Type: application/json; charset=utf-8');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

// ==================== CONFIGURAÇÃO ====================
define('EVOLUTION_API_URL', 'https://api.controlmaxerp.com.br');
define('EVOLUTION_API_KEY', '71EADE194F02-407C-8010-7150867D32BF');

// ==================== FUNÇÕES ====================
function makeEvolutionRequest($endpoint) {
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, EVOLUTION_API_URL . $endpoint);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json',
        'apikey: ' . EVOLUTION_API_KEY
    ]);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $error = curl_error($ch);
    curl_close($ch);
    
    return [
        'success' => $httpCode >= 200 && $httpCode < 300,
        'data' => json_decode($response, true),
        'httpCode' => $httpCode,
        'rawResponse' => $response,
        'error' => $error
    ];
}

// ==================== ROTEAMENTO POR QUERY STRING ====================
$requestUri = $_SERVER['REQUEST_URI'];
$queryString = $_SERVER['QUERY_STRING'] ?? '';

// Roteamento por query string
if (isset($_GET['action'])) {
    $action = $_GET['action'];
    
    // Health Check
    if ($action === 'health') {
        echo json_encode([
            'status' => 'ok',
            'timestamp' => date('Y-m-d H:i:s'),
            'message' => 'API Evolution funcionando!',
            'method' => 'query_string'
        ]);
        exit();
    }
    
    // Listar Instâncias
    if ($action === 'instances') {
        $result = makeEvolutionRequest('/instance/fetchInstances');
        
        if ($result['success']) {
            http_response_code($result['httpCode']);
            echo $result['rawResponse'];
        } else {
            http_response_code(500);
            echo json_encode([
                'error' => 'Erro ao conectar com Evolution API',
                'details' => $result['error']
            ]);
        }
        exit();
    }
    
    // Conectar Instância
    if ($action === 'connect' && isset($_GET['instance'])) {
        $instanceName = $_GET['instance'];
        $result = makeEvolutionRequest('/instance/connect/' . $instanceName);
        
        if ($result['success']) {
            http_response_code($result['httpCode']);
            echo $result['rawResponse'];
        } else {
            http_response_code(500);
            echo json_encode([
                'error' => 'Erro ao gerar QR Code',
                'details' => $result['error']
            ]);
        }
        exit();
    }
    
    // Status da Instância
    if ($action === 'status' && isset($_GET['instance'])) {
        $instanceName = $_GET['instance'];
        $result = makeEvolutionRequest('/instance/connectionState/' . $instanceName);
        
        if ($result['success']) {
            http_response_code($result['httpCode']);
            echo $result['rawResponse'];
        } else {
            http_response_code(500);
            echo json_encode([
                'error' => 'Erro ao verificar status',
                'details' => $result['error']
            ]);
        }
        exit();
    }
}

// Se não for uma ação válida, mostrar endpoints disponíveis
echo json_encode([
    'error' => 'Ação não especificada',
    'available_actions' => [
        'health' => '/client-api/?action=health',
        'instances' => '/client-api/?action=instances',
        'connect' => '/client-api/?action=connect&instance=NOME_INSTANCIA',
        'status' => '/client-api/?action=status&instance=NOME_INSTANCIA'
    ],
    'current_request' => [
        'request_uri' => $requestUri,
        'query_string' => $queryString
    ]
]);
?>